# 画面設計書 27-Master Environment（マスター環境情報）

## 概要

本ドキュメントは、マスターノードのJVM情報・Sparkプロパティ・Hadoop/システムプロパティ・環境変数を表示する画面「Master Environment（マスター環境情報）」の設計書である。

### 本画面の処理概要

本画面は、Spark Standaloneクラスタのマスターノードの実行環境に関する各種プロパティ情報を一覧表示する画面である。

**業務上の目的・背景**：Standaloneクラスタの運用において、マスターノードのJVMバージョン、Sparkの設定値、Hadoopの設定値、システムプロパティ、メトリクスプロパティ、クラスパス、環境変数を確認する必要がある。特に障害調査やクラスタ設定の検証時に、マスターノードの実行環境を正確に把握することが重要である。本画面はこれらの情報をWeb UI上で容易に確認できるようにする。

**画面へのアクセス方法**：Master Overview画面（No.24）のStatus行にあるEnvironmentリンクをクリックすることで本画面に遷移する。URLは `/environment/` である。

**主要な操作・処理内容**：
1. Runtime Information（JVM情報）の表示
2. Spark Properties（Sparkプロパティ）の表示（機密値はマスク処理）
3. Hadoop Properties（Hadoopプロパティ）の表示（機密値はマスク処理）
4. System Properties（システムプロパティ）の表示（機密値はマスク処理）
5. Metrics Properties（メトリクスプロパティ）の表示（機密値はマスク処理）
6. Classpath Entries（クラスパスエントリ）の表示
7. Environment Variables（環境変数）の表示（プレフィックスフィルタ適用）
8. 各セクションの折りたたみ/展開

**画面遷移**：
- 遷移元：Master Overview画面（No.24）のEnvironmentリンク
- 遷移先：Master Overview画面への「Back to Master」リンク

**権限による表示制御**：環境変数は `spark.master.ui.envVars.prefix` 設定で指定されたプレフィックスに一致する変数のみ表示される。Sparkプロパティ・Hadoopプロパティ・システムプロパティの機密値は `Utils.redact` によりマスク処理される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | マスターノードのJVM情報・Sparkプロパティ・Hadoop/システムプロパティ・環境変数を表示する主処理 |
| 84 | Standaloneクラスタマネージャ | 補助機能 | マスタープロセスの環境変数・リソース設定を取得して表示 |

## 画面種別

一覧（環境情報ビューア）

## URL/ルーティング

- **URL**: `/environment/`
- **HTTPメソッド**: GET
- **ページ名（WebUIPage）**: `Environment`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| なし | - | - | - | パラメータなし |

## 表示項目

### Runtime Information（初期展開）

| カラム名 | 説明 |
|----------|------|
| Name | JVM情報項目名（Java Version, Scala Version等） |
| Value | 項目値 |

### Spark Properties（初期展開）

| カラム名 | 説明 |
|----------|------|
| Name | Sparkプロパティ名 |
| Value | プロパティ値（機密値はマスク処理） |

### Hadoop Properties（初期折りたたみ）

| カラム名 | 説明 |
|----------|------|
| Name | Hadoopプロパティ名 |
| Value | プロパティ値（機密値はマスク処理） |

### System Properties（初期折りたたみ）

| カラム名 | 説明 |
|----------|------|
| Name | システムプロパティ名 |
| Value | プロパティ値（機密値はマスク処理） |

### Metrics Properties（初期折りたたみ）

| カラム名 | 説明 |
|----------|------|
| Name | メトリクスプロパティ名 |
| Value | プロパティ値（機密値はマスク処理） |

### Classpath Entries（初期折りたたみ）

| カラム名 | 説明 |
|----------|------|
| Resource | クラスパスリソース |
| Source | ソース |

### Environment Variables（初期折りたたみ）

| カラム名 | 説明 |
|----------|------|
| Name | 環境変数名 |
| Value | 環境変数値 |

## イベント仕様

### 1-ページ読み込み

1. `SparkEnv.environmentDetails` で環境詳細情報を取得する
2. JVM情報をソートして表示する
3. Sparkプロパティに `Utils.redact` を適用してソート・表示する
4. Hadoopプロパティに `Utils.redact` を適用してソート・表示する
5. システムプロパティに `Utils.redact` を適用してソート・表示する
6. メトリクスプロパティに `Utils.redact` を適用してソート・表示する
7. クラスパスエントリをソートして表示する
8. 環境変数を `MASTER_UI_VISIBLE_ENV_VAR_PREFIXES` でフィルタリングし、ソートして表示する
9. `environmentpage.js` スクリプトを読み込む

### 2-セクション折りたたみ/展開

各セクションのヘッダをクリックすると、`collapseTable` JavaScript関数で表示/非表示が切り替わる。Runtime InformationとSpark Propertiesは初期展開（arrow-open）、その他は初期折りたたみ（arrow-closed, collapsed）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ読み込み | なし | - | データベースへのアクセスなし |

データベースへの更新は発生しない。SparkConf、HadoopConf、System.getenv()からの情報取得のみ。

## メッセージ仕様

特になし。

## 例外処理

特別な例外処理はなし。SparkEnv.environmentDetailsの取得に失敗した場合はSpark UIフレームワークのデフォルトエラー処理が適用される。

## 備考

- EnvironmentPageは2つのルートで登録されている: WebUIPageとして `Environment` パス、およびServletHandlerとして `/environment` パス（MasterWebUI.scala 60-62行目）
- 機密値のマスク処理は `Utils.redact(conf, properties)` で行われ、パスワード等のキーワードを含むプロパティ値が `*********(redacted)` に置換される
- 環境変数のフィルタリングプレフィックスは `spark.master.ui.envVars.prefix` 設定（MASTER_UI_VISIBLE_ENV_VAR_PREFIXES）で制御される
- environmentpage.jsスクリプトが読み込まれるが、Standaloneマスター版ではSparkUI版と異なりResourceProfileのセクションは含まれない
- 全テーブルのヘッダクラスは `sorttable_alpha` であり、文字列としてソート可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

環境情報はSparkEnv.environmentDetailsによりMap[String, Seq[(String, String)]]として取得される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkEnv.scala | `core/src/main/scala/org/apache/spark/SparkEnv.scala` | environmentDetailsメソッド: JVM Information, Spark Properties, Hadoop Properties, System Properties, Metrics Properties, Classpath Entries をキーとするMapを返す |

**読解のコツ**: environmentDetailsの引数のうち、マスター版では schedulingMode="", addedJars=Seq.empty, addedFiles=Seq.empty, addedArchives=Seq.empty, resourceProfiles=Map.empty が渡される（アプリケーション固有の情報がないため）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EnvironmentPage.scala（master） | `core/src/main/scala/org/apache/spark/deploy/master/ui/EnvironmentPage.scala` | renderメソッド（35-148行目）: SparkEnv.environmentDetailsの呼び出し、Utils.redactによるマスク処理、各テーブルの生成、環境変数のプレフィックスフィルタリング |

**主要処理フロー**:
1. **36-37行目**: `SparkEnv.environmentDetails` で環境情報Map取得
2. **38行目**: JVM情報をソート
3. **39-42行目**: Spark/Hadoop/System/Metricsプロパティに `Utils.redact` 適用してソート
4. **43行目**: クラスパスエントリをソート
5. **44-46行目**: 環境変数を `MASTER_UI_VISIBLE_ENV_VAR_PREFIXES` でフィルタリング、ソート
6. **48-61行目**: `UIUtils.listingTable` で各テーブル生成
7. **63-146行目**: HTML構成（各セクションの折りたたみ可能テーブル）
8. **147行目**: `UIUtils.basicSparkPage` でHTMLレスポンス生成

#### Step 3: Web UIフレームワーク登録の理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MasterWebUI.scala | `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala` | initialize（58-62行目）: EnvironmentPageの2重登録（WebUIPage + ServletHandler） |

### プログラム呼び出し階層図

```
EnvironmentPage.render(request)
    |
    +-- SparkEnv.environmentDetails(conf, hadoopConf, "", Seq.empty, ...)
    |       +-- JVM Information
    |       +-- Spark Properties
    |       +-- Hadoop Properties
    |       +-- System Properties
    |       +-- Metrics Properties
    |       +-- Classpath Entries
    |
    +-- Utils.redact(conf, sparkProperties)
    +-- Utils.redact(conf, hadoopProperties)
    +-- Utils.redact(conf, systemProperties)
    +-- Utils.redact(conf, metricsProperties)
    |
    +-- System.getenv().filter(prefixes)
    |
    +-- UIUtils.listingTable() [x7: 各セクション]
    |
    +-- UIUtils.basicSparkPage(request, content, "Environment")
```

### データフロー図

```
[入力]                       [処理]                           [出力]

SparkConf               ───> SparkEnv.environmentDetails    ───> 7セクションの
HadoopConf                    |                                  プロパティテーブル
System.getProperties()        |                                  |
System.getenv()               +-- Utils.redact()            ───> マスク処理済みプロパティ
                              +-- prefixフィルタ             ───> フィルタ済み環境変数
                              |
                         UIUtils.listingTable()
                         UIUtils.basicSparkPage()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EnvironmentPage.scala | `core/src/main/scala/org/apache/spark/deploy/master/ui/EnvironmentPage.scala` | ソース | マスター環境情報画面のメインページクラス |
| MasterWebUI.scala | `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala` | ソース | ページ・ハンドラ登録 |
| SparkEnv.scala | `core/src/main/scala/org/apache/spark/SparkEnv.scala` | ソース | environmentDetailsメソッド |
| Utils.scala | `core/src/main/scala/org/apache/spark/util/Utils.scala` | ソース | redactメソッド（機密値マスク処理） |
| environmentpage.js | `core/src/main/resources/org/apache/spark/ui/static/environmentpage.js` | JavaScript | 環境情報ページのクライアントスクリプト |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | HTML生成ユーティリティ |
